import { __decorate, __metadata } from "tslib";
import { Component, ViewChild, Input, Output, EventEmitter } from '@angular/core';
let SliderComponent = class SliderComponent {
    constructor() {
        this.initialOptions = {};
        this.valueChange = new EventEmitter();
        // The following events are emitted
        this.slide = new EventEmitter();
        this.slideStart = new EventEmitter();
        this.slideStop = new EventEmitter();
        this.change = new EventEmitter();
    }
    // This property is not applied to the underlying slider element
    set style(value) {
        if (this.slider) {
            this.slider.getElement().setAttribute('style', value);
        }
        else {
            this.initialStyle = value;
        }
    }
    // Handle the value (two-way)
    set value(value) {
        if (this.slider) {
            this.slider.setValue(value);
        }
        else {
            this.initialOptions.value = value;
        }
    }
    // The following properties are applied to the underlying slider element
    set min(value) {
        this.changeAttribute('min', value);
    }
    set max(value) {
        this.changeAttribute('max', value);
    }
    set step(value) {
        this.changeAttribute('step', value);
    }
    set precision(value) {
        this.changeAttribute('precision', value);
    }
    set orientation(value) {
        this.changeAttribute('orientation', value);
    }
    set range(value) {
        this.changeAttribute('range', value);
    }
    set selection(value) {
        this.changeAttribute('selection', value);
    }
    set tooltip(value) {
        this.changeAttribute('tooltip', value);
    }
    set tooltipSplit(value) {
        this.changeAttribute('tooltip_split', value);
    }
    set tooltipPosition(value) {
        this.changeAttribute('tooltip_position', value);
    }
    set handle(value) {
        this.changeAttribute('handle', value);
    }
    set reversed(value) {
        this.changeAttribute('reversed', value);
    }
    set rtl(value) {
        this.changeAttribute('rtl', value);
    }
    set enabled(value) {
        this.changeAttribute('enabled', value);
    }
    set naturalArrowKeys(value) {
        this.changeAttribute('natural_arrow_keys', value);
    }
    set ticks(value) {
        this.changeAttribute('ticks', value);
    }
    set ticksPositions(value) {
        this.changeAttribute('ticks_positions', value);
    }
    set ticksLabels(value) {
        this.changeAttribute('ticks_labels', value);
    }
    set ticksSnapBounds(value) {
        this.changeAttribute('ticks_snap_bounds', value);
    }
    set ticksTooltip(value) {
        this.changeAttribute('ticks_tooltip', value);
    }
    set scale(value) {
        this.changeAttribute('scale', value);
    }
    set labelledBy(value) {
        this.changeAttribute('labelledby', value);
    }
    set rangeHighlights(value) {
        this.changeAttribute('rangeHighlights', value);
    }
    set formatter(value) {
        this.changeAttribute('formatter', value);
    }
    set lockToTicks(value) {
        this.changeAttribute('lock_to_ticks', value);
    }
    addChangeListeners() {
        this.slider.on('slide', (value) => {
            this.slide.emit(value);
        });
        this.slider.on('slideStart', (value) => {
            this.slideStart.emit(value);
        });
        this.slider.on('slideStop', (value) => {
            this.slideStop.emit(value);
        });
        this.slider.on('change', (event) => {
            this.change.emit(event);
            this.valueChange.emit(event.newValue);
        });
    }
    prepareSlider() {
        // We need to add the change listeners again after each refresh
        this.addChangeListeners();
        // Add the styling to the element
        this.slider.getElement().setAttribute('style', this.initialStyle);
    }
    changeAttribute(name, value) {
        if (this.slider) {
            this.slider.setAttribute(name, value);
            this.slider.refresh();
            this.prepareSlider();
        }
        else {
            this.initialOptions[name] = value;
        }
    }
    ngOnInit() {
        // Don't set the value over the initial options, because it will alway
        // be reset. This option seems to be a little buggy.
        let value = undefined;
        if (this.initialOptions.value) {
            value = this.initialOptions.value;
            delete this.initialOptions['value'];
        }
        this.slider = new Slider(this.sliderElement.nativeElement, this.initialOptions);
        if (value) {
            this.slider.setValue(value);
        }
        this.prepareSlider();
    }
};
__decorate([
    ViewChild('slider', { static: true }),
    __metadata("design:type", Object)
], SliderComponent.prototype, "sliderElement", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [Object])
], SliderComponent.prototype, "style", null);
__decorate([
    Input(),
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [Object])
], SliderComponent.prototype, "value", null);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "valueChange", void 0);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "min", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "max", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "step", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "precision", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "orientation", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "range", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "selection", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "tooltip", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "tooltipSplit", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "tooltipPosition", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "handle", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "reversed", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "rtl", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "enabled", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "naturalArrowKeys", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "ticks", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "ticksPositions", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "ticksLabels", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "ticksSnapBounds", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "ticksTooltip", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "scale", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "labelledBy", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "rangeHighlights", null);
__decorate([
    Input(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function])
], SliderComponent.prototype, "formatter", null);
__decorate([
    Input(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function])
], SliderComponent.prototype, "lockToTicks", null);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "slide", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "slideStart", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "slideStop", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "change", void 0);
SliderComponent = __decorate([
    Component({
        selector: 'mv-slider',
        template: "<input #slider>",
        styles: [""]
    }),
    __metadata("design:paramtypes", [])
], SliderComponent);
export { SliderComponent };
//# sourceMappingURL=data:application/json;base64,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