import { __decorate, __metadata } from "tslib";
import { Component, ViewChild, Input, Output, EventEmitter } from '@angular/core';
var SliderComponent = /** @class */ (function () {
    function SliderComponent() {
        this.initialOptions = {};
        this.valueChange = new EventEmitter();
        // The following events are emitted
        this.slide = new EventEmitter();
        this.slideStart = new EventEmitter();
        this.slideStop = new EventEmitter();
        this.change = new EventEmitter();
    }
    Object.defineProperty(SliderComponent.prototype, "style", {
        // This property is not applied to the underlying slider element
        set: function (value) {
            if (this.slider) {
                this.slider.getElement().setAttribute('style', value);
            }
            else {
                this.initialStyle = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "value", {
        // Handle the value (two-way)
        set: function (value) {
            if (this.slider) {
                this.slider.setValue(value);
            }
            else {
                this.initialOptions.value = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "min", {
        // The following properties are applied to the underlying slider element
        set: function (value) {
            this.changeAttribute('min', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "max", {
        set: function (value) {
            this.changeAttribute('max', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "step", {
        set: function (value) {
            this.changeAttribute('step', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "precision", {
        set: function (value) {
            this.changeAttribute('precision', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "orientation", {
        set: function (value) {
            this.changeAttribute('orientation', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "range", {
        set: function (value) {
            this.changeAttribute('range', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "selection", {
        set: function (value) {
            this.changeAttribute('selection', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "tooltip", {
        set: function (value) {
            this.changeAttribute('tooltip', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "tooltipSplit", {
        set: function (value) {
            this.changeAttribute('tooltip_split', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "tooltipPosition", {
        set: function (value) {
            this.changeAttribute('tooltip_position', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "handle", {
        set: function (value) {
            this.changeAttribute('handle', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "reversed", {
        set: function (value) {
            this.changeAttribute('reversed', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "rtl", {
        set: function (value) {
            this.changeAttribute('rtl', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "enabled", {
        set: function (value) {
            this.changeAttribute('enabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "naturalArrowKeys", {
        set: function (value) {
            this.changeAttribute('natural_arrow_keys', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticks", {
        set: function (value) {
            this.changeAttribute('ticks', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticksPositions", {
        set: function (value) {
            this.changeAttribute('ticks_positions', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticksLabels", {
        set: function (value) {
            this.changeAttribute('ticks_labels', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticksSnapBounds", {
        set: function (value) {
            this.changeAttribute('ticks_snap_bounds', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticksTooltip", {
        set: function (value) {
            this.changeAttribute('ticks_tooltip', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "scale", {
        set: function (value) {
            this.changeAttribute('scale', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "labelledBy", {
        set: function (value) {
            this.changeAttribute('labelledby', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "rangeHighlights", {
        set: function (value) {
            this.changeAttribute('rangeHighlights', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "formatter", {
        set: function (value) {
            this.changeAttribute('formatter', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "lockToTicks", {
        set: function (value) {
            this.changeAttribute('lock_to_ticks', value);
        },
        enumerable: true,
        configurable: true
    });
    SliderComponent.prototype.addChangeListeners = function () {
        var _this = this;
        this.slider.on('slide', function (value) {
            _this.slide.emit(value);
        });
        this.slider.on('slideStart', function (value) {
            _this.slideStart.emit(value);
        });
        this.slider.on('slideStop', function (value) {
            _this.slideStop.emit(value);
        });
        this.slider.on('change', function (event) {
            _this.change.emit(event);
            _this.valueChange.emit(event.newValue);
        });
    };
    SliderComponent.prototype.prepareSlider = function () {
        // We need to add the change listeners again after each refresh
        this.addChangeListeners();
        // Add the styling to the element
        this.slider.getElement().setAttribute('style', this.initialStyle);
    };
    SliderComponent.prototype.changeAttribute = function (name, value) {
        if (this.slider) {
            this.slider.setAttribute(name, value);
            this.slider.refresh();
            this.prepareSlider();
        }
        else {
            this.initialOptions[name] = value;
        }
    };
    SliderComponent.prototype.ngOnInit = function () {
        // Don't set the value over the initial options, because it will alway
        // be reset. This option seems to be a little buggy.
        var value = undefined;
        if (this.initialOptions.value) {
            value = this.initialOptions.value;
            delete this.initialOptions['value'];
        }
        this.slider = new Slider(this.sliderElement.nativeElement, this.initialOptions);
        if (value) {
            this.slider.setValue(value);
        }
        this.prepareSlider();
    };
    __decorate([
        ViewChild('slider', { static: true }),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "sliderElement", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object),
        __metadata("design:paramtypes", [Object])
    ], SliderComponent.prototype, "style", null);
    __decorate([
        Input(),
        __metadata("design:type", Object),
        __metadata("design:paramtypes", [Object])
    ], SliderComponent.prototype, "value", null);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "valueChange", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "min", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "max", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "step", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "precision", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "orientation", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "range", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "selection", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "tooltip", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "tooltipSplit", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "tooltipPosition", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "handle", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "reversed", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "rtl", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "enabled", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "naturalArrowKeys", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "ticks", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "ticksPositions", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "ticksLabels", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "ticksSnapBounds", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "ticksTooltip", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "scale", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "labelledBy", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "rangeHighlights", null);
    __decorate([
        Input(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function])
    ], SliderComponent.prototype, "formatter", null);
    __decorate([
        Input(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function])
    ], SliderComponent.prototype, "lockToTicks", null);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "slide", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "slideStart", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "slideStop", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "change", void 0);
    SliderComponent = __decorate([
        Component({
            selector: 'mv-slider',
            template: "<input #slider>",
            styles: [""]
        }),
        __metadata("design:paramtypes", [])
    ], SliderComponent);
    return SliderComponent;
}());
export { SliderComponent };
//# sourceMappingURL=data:application/json;base64,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