import { __decorate, __metadata } from 'tslib';
import { ɵɵdefineInjectable, Injectable, Component, EventEmitter, ViewChild, Input, Output, NgModule } from '@angular/core';

let NgxBootstrapSliderService = class NgxBootstrapSliderService {
    constructor() {
    }
};
NgxBootstrapSliderService.ɵprov = ɵɵdefineInjectable({ factory: function NgxBootstrapSliderService_Factory() { return new NgxBootstrapSliderService(); }, token: NgxBootstrapSliderService, providedIn: "root" });
NgxBootstrapSliderService = __decorate([
    Injectable({
        providedIn: 'root'
    }),
    __metadata("design:paramtypes", [])
], NgxBootstrapSliderService);

let NgxBootstrapSliderComponent = class NgxBootstrapSliderComponent {
    constructor() { }
    ngOnInit() {
    }
};
NgxBootstrapSliderComponent = __decorate([
    Component({
        selector: 'mv-ngx-bootstrap-slider',
        template: `
    <p>
      ngx-bootstrap-slider works!
    </p>
  `
    }),
    __metadata("design:paramtypes", [])
], NgxBootstrapSliderComponent);

let SliderComponent = class SliderComponent {
    constructor() {
        this.initialOptions = {};
        this.valueChange = new EventEmitter();
        // The following events are emitted
        this.slide = new EventEmitter();
        this.slideStart = new EventEmitter();
        this.slideStop = new EventEmitter();
        this.change = new EventEmitter();
    }
    // This property is not applied to the underlying slider element
    set style(value) {
        if (this.slider) {
            this.slider.getElement().setAttribute('style', value);
        }
        else {
            this.initialStyle = value;
        }
    }
    // Handle the value (two-way)
    set value(value) {
        if (this.slider) {
            this.slider.setValue(value);
        }
        else {
            this.initialOptions.value = value;
        }
    }
    // The following properties are applied to the underlying slider element
    set min(value) {
        this.changeAttribute('min', value);
    }
    set max(value) {
        this.changeAttribute('max', value);
    }
    set step(value) {
        this.changeAttribute('step', value);
    }
    set precision(value) {
        this.changeAttribute('precision', value);
    }
    set orientation(value) {
        this.changeAttribute('orientation', value);
    }
    set range(value) {
        this.changeAttribute('range', value);
    }
    set selection(value) {
        this.changeAttribute('selection', value);
    }
    set tooltip(value) {
        this.changeAttribute('tooltip', value);
    }
    set tooltipSplit(value) {
        this.changeAttribute('tooltip_split', value);
    }
    set tooltipPosition(value) {
        this.changeAttribute('tooltip_position', value);
    }
    set handle(value) {
        this.changeAttribute('handle', value);
    }
    set reversed(value) {
        this.changeAttribute('reversed', value);
    }
    set rtl(value) {
        this.changeAttribute('rtl', value);
    }
    set enabled(value) {
        this.changeAttribute('enabled', value);
    }
    set naturalArrowKeys(value) {
        this.changeAttribute('natural_arrow_keys', value);
    }
    set ticks(value) {
        this.changeAttribute('ticks', value);
    }
    set ticksPositions(value) {
        this.changeAttribute('ticks_positions', value);
    }
    set ticksLabels(value) {
        this.changeAttribute('ticks_labels', value);
    }
    set ticksSnapBounds(value) {
        this.changeAttribute('ticks_snap_bounds', value);
    }
    set ticksTooltip(value) {
        this.changeAttribute('ticks_tooltip', value);
    }
    set scale(value) {
        this.changeAttribute('scale', value);
    }
    set labelledBy(value) {
        this.changeAttribute('labelledby', value);
    }
    set rangeHighlights(value) {
        this.changeAttribute('rangeHighlights', value);
    }
    set formatter(value) {
        this.changeAttribute('formatter', value);
    }
    set lockToTicks(value) {
        this.changeAttribute('lock_to_ticks', value);
    }
    addChangeListeners() {
        this.slider.on('slide', (value) => {
            this.slide.emit(value);
        });
        this.slider.on('slideStart', (value) => {
            this.slideStart.emit(value);
        });
        this.slider.on('slideStop', (value) => {
            this.slideStop.emit(value);
        });
        this.slider.on('change', (event) => {
            this.change.emit(event);
            this.valueChange.emit(event.newValue);
        });
    }
    prepareSlider() {
        // We need to add the change listeners again after each refresh
        this.addChangeListeners();
        // Add the styling to the element
        this.slider.getElement().setAttribute('style', this.initialStyle);
    }
    changeAttribute(name, value) {
        if (this.slider) {
            this.slider.setAttribute(name, value);
            this.slider.refresh();
            this.prepareSlider();
        }
        else {
            this.initialOptions[name] = value;
        }
    }
    ngOnInit() {
        // Don't set the value over the initial options, because it will alway
        // be reset. This option seems to be a little buggy.
        let value = undefined;
        if (this.initialOptions.value) {
            value = this.initialOptions.value;
            delete this.initialOptions['value'];
        }
        this.slider = new Slider(this.sliderElement.nativeElement, this.initialOptions);
        if (value) {
            this.slider.setValue(value);
        }
        this.prepareSlider();
    }
};
__decorate([
    ViewChild('slider', { static: true }),
    __metadata("design:type", Object)
], SliderComponent.prototype, "sliderElement", void 0);
__decorate([
    Input(),
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [Object])
], SliderComponent.prototype, "style", null);
__decorate([
    Input(),
    __metadata("design:type", Object),
    __metadata("design:paramtypes", [Object])
], SliderComponent.prototype, "value", null);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "valueChange", void 0);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "min", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "max", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "step", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "precision", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "orientation", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "range", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "selection", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "tooltip", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "tooltipSplit", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "tooltipPosition", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "handle", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "reversed", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "rtl", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "enabled", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "naturalArrowKeys", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "ticks", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "ticksPositions", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "ticksLabels", null);
__decorate([
    Input(),
    __metadata("design:type", Number),
    __metadata("design:paramtypes", [Number])
], SliderComponent.prototype, "ticksSnapBounds", null);
__decorate([
    Input(),
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [Boolean])
], SliderComponent.prototype, "ticksTooltip", null);
__decorate([
    Input(),
    __metadata("design:type", String),
    __metadata("design:paramtypes", [String])
], SliderComponent.prototype, "scale", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "labelledBy", null);
__decorate([
    Input(),
    __metadata("design:type", Array),
    __metadata("design:paramtypes", [Array])
], SliderComponent.prototype, "rangeHighlights", null);
__decorate([
    Input(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function])
], SliderComponent.prototype, "formatter", null);
__decorate([
    Input(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Function])
], SliderComponent.prototype, "lockToTicks", null);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "slide", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "slideStart", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "slideStop", void 0);
__decorate([
    Output(),
    __metadata("design:type", Object)
], SliderComponent.prototype, "change", void 0);
SliderComponent = __decorate([
    Component({
        selector: 'mv-slider',
        template: "<input #slider>",
        styles: [""]
    }),
    __metadata("design:paramtypes", [])
], SliderComponent);

let NgxBootstrapSliderModule = class NgxBootstrapSliderModule {
};
NgxBootstrapSliderModule = __decorate([
    NgModule({
        imports: [],
        declarations: [NgxBootstrapSliderComponent, SliderComponent],
        exports: [
            NgxBootstrapSliderComponent,
            SliderComponent
        ]
    })
], NgxBootstrapSliderModule);

/*
 * Public API Surface of ngx-bootstrap-slider
 */

/**
 * Generated bundle index. Do not edit.
 */

export { NgxBootstrapSliderComponent, NgxBootstrapSliderModule, NgxBootstrapSliderService, SliderComponent };
//# sourceMappingURL=ngx-bootstrap-slider.js.map
