import { __decorate, __metadata } from 'tslib';
import { ɵɵdefineInjectable, Injectable, Component, EventEmitter, ViewChild, Input, Output, NgModule } from '@angular/core';

var NgxBootstrapSliderService = /** @class */ (function () {
    function NgxBootstrapSliderService() {
    }
    NgxBootstrapSliderService.ɵprov = ɵɵdefineInjectable({ factory: function NgxBootstrapSliderService_Factory() { return new NgxBootstrapSliderService(); }, token: NgxBootstrapSliderService, providedIn: "root" });
    NgxBootstrapSliderService = __decorate([
        Injectable({
            providedIn: 'root'
        }),
        __metadata("design:paramtypes", [])
    ], NgxBootstrapSliderService);
    return NgxBootstrapSliderService;
}());

var NgxBootstrapSliderComponent = /** @class */ (function () {
    function NgxBootstrapSliderComponent() {
    }
    NgxBootstrapSliderComponent.prototype.ngOnInit = function () {
    };
    NgxBootstrapSliderComponent = __decorate([
        Component({
            selector: 'mv-ngx-bootstrap-slider',
            template: "\n    <p>\n      ngx-bootstrap-slider works!\n    </p>\n  "
        }),
        __metadata("design:paramtypes", [])
    ], NgxBootstrapSliderComponent);
    return NgxBootstrapSliderComponent;
}());

var SliderComponent = /** @class */ (function () {
    function SliderComponent() {
        this.initialOptions = {};
        this.valueChange = new EventEmitter();
        // The following events are emitted
        this.slide = new EventEmitter();
        this.slideStart = new EventEmitter();
        this.slideStop = new EventEmitter();
        this.change = new EventEmitter();
    }
    Object.defineProperty(SliderComponent.prototype, "style", {
        // This property is not applied to the underlying slider element
        set: function (value) {
            if (this.slider) {
                this.slider.getElement().setAttribute('style', value);
            }
            else {
                this.initialStyle = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "value", {
        // Handle the value (two-way)
        set: function (value) {
            if (this.slider) {
                this.slider.setValue(value);
            }
            else {
                this.initialOptions.value = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "min", {
        // The following properties are applied to the underlying slider element
        set: function (value) {
            this.changeAttribute('min', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "max", {
        set: function (value) {
            this.changeAttribute('max', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "step", {
        set: function (value) {
            this.changeAttribute('step', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "precision", {
        set: function (value) {
            this.changeAttribute('precision', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "orientation", {
        set: function (value) {
            this.changeAttribute('orientation', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "range", {
        set: function (value) {
            this.changeAttribute('range', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "selection", {
        set: function (value) {
            this.changeAttribute('selection', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "tooltip", {
        set: function (value) {
            this.changeAttribute('tooltip', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "tooltipSplit", {
        set: function (value) {
            this.changeAttribute('tooltip_split', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "tooltipPosition", {
        set: function (value) {
            this.changeAttribute('tooltip_position', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "handle", {
        set: function (value) {
            this.changeAttribute('handle', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "reversed", {
        set: function (value) {
            this.changeAttribute('reversed', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "rtl", {
        set: function (value) {
            this.changeAttribute('rtl', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "enabled", {
        set: function (value) {
            this.changeAttribute('enabled', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "naturalArrowKeys", {
        set: function (value) {
            this.changeAttribute('natural_arrow_keys', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticks", {
        set: function (value) {
            this.changeAttribute('ticks', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticksPositions", {
        set: function (value) {
            this.changeAttribute('ticks_positions', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticksLabels", {
        set: function (value) {
            this.changeAttribute('ticks_labels', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticksSnapBounds", {
        set: function (value) {
            this.changeAttribute('ticks_snap_bounds', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "ticksTooltip", {
        set: function (value) {
            this.changeAttribute('ticks_tooltip', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "scale", {
        set: function (value) {
            this.changeAttribute('scale', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "labelledBy", {
        set: function (value) {
            this.changeAttribute('labelledby', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "rangeHighlights", {
        set: function (value) {
            this.changeAttribute('rangeHighlights', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "formatter", {
        set: function (value) {
            this.changeAttribute('formatter', value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SliderComponent.prototype, "lockToTicks", {
        set: function (value) {
            this.changeAttribute('lock_to_ticks', value);
        },
        enumerable: true,
        configurable: true
    });
    SliderComponent.prototype.addChangeListeners = function () {
        var _this = this;
        this.slider.on('slide', function (value) {
            _this.slide.emit(value);
        });
        this.slider.on('slideStart', function (value) {
            _this.slideStart.emit(value);
        });
        this.slider.on('slideStop', function (value) {
            _this.slideStop.emit(value);
        });
        this.slider.on('change', function (event) {
            _this.change.emit(event);
            _this.valueChange.emit(event.newValue);
        });
    };
    SliderComponent.prototype.prepareSlider = function () {
        // We need to add the change listeners again after each refresh
        this.addChangeListeners();
        // Add the styling to the element
        this.slider.getElement().setAttribute('style', this.initialStyle);
    };
    SliderComponent.prototype.changeAttribute = function (name, value) {
        if (this.slider) {
            this.slider.setAttribute(name, value);
            this.slider.refresh();
            this.prepareSlider();
        }
        else {
            this.initialOptions[name] = value;
        }
    };
    SliderComponent.prototype.ngOnInit = function () {
        // Don't set the value over the initial options, because it will alway
        // be reset. This option seems to be a little buggy.
        var value = undefined;
        if (this.initialOptions.value) {
            value = this.initialOptions.value;
            delete this.initialOptions['value'];
        }
        this.slider = new Slider(this.sliderElement.nativeElement, this.initialOptions);
        if (value) {
            this.slider.setValue(value);
        }
        this.prepareSlider();
    };
    __decorate([
        ViewChild('slider', { static: true }),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "sliderElement", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Object),
        __metadata("design:paramtypes", [Object])
    ], SliderComponent.prototype, "style", null);
    __decorate([
        Input(),
        __metadata("design:type", Object),
        __metadata("design:paramtypes", [Object])
    ], SliderComponent.prototype, "value", null);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "valueChange", void 0);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "min", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "max", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "step", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "precision", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "orientation", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "range", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "selection", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "tooltip", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "tooltipSplit", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "tooltipPosition", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "handle", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "reversed", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "rtl", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "enabled", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "naturalArrowKeys", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "ticks", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "ticksPositions", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "ticksLabels", null);
    __decorate([
        Input(),
        __metadata("design:type", Number),
        __metadata("design:paramtypes", [Number])
    ], SliderComponent.prototype, "ticksSnapBounds", null);
    __decorate([
        Input(),
        __metadata("design:type", Boolean),
        __metadata("design:paramtypes", [Boolean])
    ], SliderComponent.prototype, "ticksTooltip", null);
    __decorate([
        Input(),
        __metadata("design:type", String),
        __metadata("design:paramtypes", [String])
    ], SliderComponent.prototype, "scale", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "labelledBy", null);
    __decorate([
        Input(),
        __metadata("design:type", Array),
        __metadata("design:paramtypes", [Array])
    ], SliderComponent.prototype, "rangeHighlights", null);
    __decorate([
        Input(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function])
    ], SliderComponent.prototype, "formatter", null);
    __decorate([
        Input(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", [Function])
    ], SliderComponent.prototype, "lockToTicks", null);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "slide", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "slideStart", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "slideStop", void 0);
    __decorate([
        Output(),
        __metadata("design:type", Object)
    ], SliderComponent.prototype, "change", void 0);
    SliderComponent = __decorate([
        Component({
            selector: 'mv-slider',
            template: "<input #slider>",
            styles: [""]
        }),
        __metadata("design:paramtypes", [])
    ], SliderComponent);
    return SliderComponent;
}());

var NgxBootstrapSliderModule = /** @class */ (function () {
    function NgxBootstrapSliderModule() {
    }
    NgxBootstrapSliderModule = __decorate([
        NgModule({
            imports: [],
            declarations: [NgxBootstrapSliderComponent, SliderComponent],
            exports: [
                NgxBootstrapSliderComponent,
                SliderComponent
            ]
        })
    ], NgxBootstrapSliderModule);
    return NgxBootstrapSliderModule;
}());

/*
 * Public API Surface of ngx-bootstrap-slider
 */

/**
 * Generated bundle index. Do not edit.
 */

export { NgxBootstrapSliderComponent, NgxBootstrapSliderModule, NgxBootstrapSliderService, SliderComponent };
//# sourceMappingURL=ngx-bootstrap-slider.js.map
